using System;
using UnityEngine;

namespace StateMachine
{
    [Serializable]
    public class State : ScriptableObject
    {
        [SerializeField] new string name;
        [SerializeField] StateConditioner conditioner;
        [SerializeField] StateExecuter executer;

        public void Run()
        {
            executer.Run();
        }

        public void UpdateParameters(in ParameterContainer c)
        {
            conditioner.parameter = c;
            executer.parameter = c;
        }
    }
}
